using System;
using System.IO;

public class ExceptionTester
{
    public static int Main(string[] args)
    {
        ExceptionTester myExceptionMaker = 
            new ExceptionTester();

        try
        {
            myExceptionMaker.GenerateException();
        }
        catch (Exception e)
        {
            Console.WriteLine(
                "\nPrzetwarzanie wyjtku Main():");
            while (e != null)
            {
                Console.WriteLine("\tWyjtek wewntrzny: {0}", e.Message);
                e = e.InnerException;
            }
        }
        finally
        {
            Console.WriteLine("Wywoanie bloku finally z Main()");
        }

        return 0;
    }

    void GenerateException()
    {
        int mySize = 3;
        byte[] myStream = new byte[mySize];
        int iterations = 5;

        do
        {
            StreamWriter sw = 
                new StreamWriter("exceptions.txt");

            try
            {
                for (byte b=0; b < iterations; b++)
                {
                    sw.WriteLine("Byte {0}: {1}", b+1, b);
                    myStream[b] = b;
                }
                break;
            }
            catch (IndexOutOfRangeException iore)
            {
                Console.WriteLine(
"\nWyjtek 'indeks poza zakresem' w metodzie GenerateException: {0}: {0}",
iore.Message);
                iterations--;
            }
            catch (Exception e)
            {
                Console.WriteLine(
"\nZgoszenie wyjtku z GenerateException: {0}", e.Message);
            }
            finally
            {
                Console.WriteLine(
                    "Wywoanie bloku finally z GenerateException.");
                sw.WriteLine("Close");
                sw.Close();
            }
        } while (true);
    }
}
